/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/GUIForms/JFrame.java to edit this template
 */
package buoi2.jfc;

import javax.swing.JOptionPane;

/**
 *
 * @author dung
 */
public class CheckoutFrame extends javax.swing.JFrame {

    /**
     * Creates new form PaymentFrame
     */
    public CheckoutFrame() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbl_title = new javax.swing.JLabel();
        lbl_invoice = new javax.swing.JLabel();
        lbl_id = new javax.swing.JLabel();
        lbl_name = new javax.swing.JLabel();
        lbl_idcard = new javax.swing.JLabel();
        lbl_room = new javax.swing.JLabel();
        lbl_amount = new javax.swing.JLabel();
        txt_invoice = new javax.swing.JTextField();
        txt_id = new javax.swing.JTextField();
        txt_name = new javax.swing.JTextField();
        txt_idcard = new javax.swing.JTextField();
        cbobox_room = new javax.swing.JComboBox<>();
        txt_amount = new javax.swing.JFormattedTextField();
        btn_agree = new javax.swing.JButton();
        btn_cancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Khách sạn Phương Nam");
        setResizable(false);

        lbl_title.setFont(new java.awt.Font("Cantarell", 1, 24)); // NOI18N
        lbl_title.setText("Bảng thanh toán");

        lbl_invoice.setText("Số hóa đơn");

        lbl_id.setText("Mã khách hàng");

        lbl_name.setText("Tên khách hàng");

        lbl_idcard.setText("Số CMND");

        lbl_room.setText("Số phòng");

        lbl_amount.setText("Số tiền thanh toán");

        txt_invoice.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                txt_invoiceKeyTyped(evt);
            }
        });

        txt_id.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                txt_idKeyTyped(evt);
            }
        });

        txt_idcard.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                txt_idcardKeyTyped(evt);
            }
        });

        cbobox_room.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "101", "201", "301", " " }));

        txt_amount.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("#0"))));
        txt_amount.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                txt_amountKeyTyped(evt);
            }
        });

        btn_agree.setText("Đồng ý");
        btn_agree.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_agreeActionPerformed(evt);
            }
        });

        btn_cancel.setText("Hủy bỏ");
        btn_cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_cancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(24, 24, 24)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lbl_invoice)
                    .addComponent(lbl_id)
                    .addComponent(lbl_name)
                    .addComponent(lbl_idcard)
                    .addComponent(lbl_room)
                    .addComponent(lbl_amount))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(txt_name, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(txt_amount, javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(txt_idcard, javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(txt_invoice, javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(cbobox_room, javax.swing.GroupLayout.Alignment.LEADING, 0, 125, Short.MAX_VALUE)
                        .addComponent(txt_id, javax.swing.GroupLayout.Alignment.LEADING)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(lbl_title)
                        .addGap(111, 111, 111))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(btn_agree, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(btn_cancel, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(126, 126, 126))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addComponent(lbl_title)
                .addGap(30, 30, 30)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_invoice)
                    .addComponent(txt_invoice, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_id)
                    .addComponent(txt_id, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_name)
                    .addComponent(txt_name, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_idcard)
                    .addComponent(txt_idcard, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(11, 11, 11)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_room)
                    .addComponent(cbobox_room, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbl_amount)
                    .addComponent(txt_amount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btn_agree)
                    .addComponent(btn_cancel))
                .addGap(22, 22, 22))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void txt_idKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_txt_idKeyTyped
        if (!Character.isDigit(evt.getKeyChar()) || txt_id.getText().length() > 6) {
            evt.consume();
            return;
        }
        if (!txt_id.getText().startsWith("PN-")) {
            txt_id.setText("PN-" + txt_id.getText());
        }
    }//GEN-LAST:event_txt_idKeyTyped

    private void txt_invoiceKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_txt_invoiceKeyTyped
        if (!Character.isDigit(evt.getKeyChar()) || txt_invoice.getText().length() == 4) {
            evt.consume();
        }
    }//GEN-LAST:event_txt_invoiceKeyTyped

    private void txt_idcardKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_txt_idcardKeyTyped
        if (!Character.isDigit(evt.getKeyChar()) || txt_idcard.getText().length() == 9) {
            evt.consume();
        }
    }//GEN-LAST:event_txt_idcardKeyTyped

    private void txt_amountKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_txt_amountKeyTyped
        if (!Character.isDigit(evt.getKeyChar())) {
            evt.consume();
        }
    }//GEN-LAST:event_txt_amountKeyTyped

    private void btn_agreeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_agreeActionPerformed
        if (txt_invoice.getText().length() < 4) {
            JOptionPane.showMessageDialog(this, "Số hóa đơn phải gồm 4 chữ số.", "Lỗi", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (txt_id.getText().length() < 7) {
            JOptionPane.showMessageDialog(this, "Mã khách hàng phải có dạng PN-XXXX.", "Lỗi", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (txt_name.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Tên khách hàng không được để trống.", "Lỗi", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (txt_idcard.getText().length() < 9) {
            JOptionPane.showMessageDialog(this, "Số CMND phải gồm 9 chữ số.", "Lỗi", JOptionPane.ERROR_MESSAGE);
            return;
        }
        String input = new String();
        input += String.format("%s: %s\n", lbl_invoice.getText(), txt_invoice.getText());
        input += String.format("%s: %s\n", lbl_id.getText(), txt_id.getText());
        input += String.format("%s: %s\n", lbl_name.getText(), txt_name.getText());
        input += String.format("%s: %s\n", lbl_idcard.getText(), txt_idcard.getText());
        input += String.format("%s: %s\n", lbl_room.getText(), cbobox_room.getSelectedItem());
        input += String.format("%s: %s\n", lbl_amount.getText(), txt_amount.getText());
        JOptionPane.showMessageDialog(this, input, "Thông tin đã nhập", JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_btn_agreeActionPerformed

    private void btn_cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_cancelActionPerformed
        txt_amount.setText("");
        txt_id.setText("");
        txt_idcard.setText("");
        txt_invoice.setText("");
        txt_name.setText("");
    }//GEN-LAST:event_btn_cancelActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(CheckoutFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(CheckoutFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(CheckoutFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(CheckoutFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CheckoutFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btn_agree;
    private javax.swing.JButton btn_cancel;
    private javax.swing.JComboBox<String> cbobox_room;
    private javax.swing.JLabel lbl_amount;
    private javax.swing.JLabel lbl_id;
    private javax.swing.JLabel lbl_idcard;
    private javax.swing.JLabel lbl_invoice;
    private javax.swing.JLabel lbl_name;
    private javax.swing.JLabel lbl_room;
    private javax.swing.JLabel lbl_title;
    private javax.swing.JFormattedTextField txt_amount;
    private javax.swing.JTextField txt_id;
    private javax.swing.JTextField txt_idcard;
    private javax.swing.JTextField txt_invoice;
    private javax.swing.JTextField txt_name;
    // End of variables declaration//GEN-END:variables
}
